/* Copyright (C) 2016-2018 RealVNC Ltd.  All Rights Reserved.
 */

#ifndef EVENTHANDLETOGGLABLE_H_127219782513976535761594179790584872627
#define EVENTHANDLETOGGLABLE_H_127219782513976535761594179790584872627

#include <vnccommon/EventHandle.h>
#include <vnccommon/StaticUtils.h>
#include <vnccommon/VirtualBase.h>

#include <memory>


/**
 * \cond VNCCOMMON
 */
namespace vnccommon
{

// Not currently implemented on Windows
class EventHandleTogglable
{
    VNCCOMMON_DISALLOW_COPYING(EventHandleTogglable);

public:
    EventHandleTogglable();

    // Note: synchronisation is needed when invoking these methods from
    // multiple threads.
    void set();
    void unset();

    EventHandle getEventHandle() const;
    DirectedEventHandle getDirectedEventHandle() const;

private:
    // Hide platform-specific members
    class Inner : public VirtualBase {};
    class InnerImpl;
    std::auto_ptr<Inner> mImpl;
};

}
/**
 * \endcond
 */

#endif // EVENTHANDLETOGGLABLE_H_127219782513976535761594179790584872627

